
protocol Printer {
   var name: String { get set }
   func printdescription()
}
protocol Highlight {
   func highlightName()
}

struct Employees: Printer, Highlight {
   var name: String
   var age: Int
    
   func printdescription() {
      print("Description: \(name) \(age)")
   }
   func highlightName() {
      print(name.uppercased())
   }
}
func getEmployee() -> Printer & Highlight {
   let employee = Employees(name: "John", age: 32)
   return employee
}
let badge = getEmployee()
badge.printdescription()  // "Description: John 32"
badge.highlightName()  // "JOHN"
